/* Copyright (c) 2016-2018 VMware, Inc. All rights reserved. */
package com.vmware.automatic.plugin.registration.commands;

import com.vmware.automatic.plugin.registration.services.ConnectionService;
import com.vmware.automatic.plugin.registration.services.PluginExtensionRegistryService;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

/**
 * An abstract class that implements common logic for Register- and UpdateCmd.
 * Parses the common command line arguments for both commands.
 * <p>
 * <b>Command line arguments:</b>
 * -serverThumbprint <SERVER_THUMB_PRINT>               - optional, when pluginUrl is HTTPS, thumbprint of plugin server's SSL certificate
 * -name <PLUGIN_NAME>                                  - optional, name of the plugin
 * -summary <PLUGIN_SUMMARY>                            - optional, brief description
 * -company <PLUGIN_COMPANY>                            - optional, company that owns the plugin
 * -showInSolutionManager                               - optional, if specified the plugin will be shown in Administration panel, Solutions plug-in list
 * -local                                               - optional, true for local plugins. Defaults to false.
 * -remote                                              - optional, true for remote plugins.
 */
public abstract class PluginRegistryCmd extends PluginCmd {

   public PluginRegistryCmd(ConnectionService connectionService,
         PluginExtensionRegistryService registryService,
         CommandLineParser parser) {
      super(connectionService, registryService, parser);
   }

   @Override
   public Options getPluginOpts() {
      Options options = super.getPluginOpts();
      options.addOption(
            Option.builder("n").longOpt("name").hasArg().argName("name")
                  .desc("Plugin name").required(false).build());
      options.addOption(
            Option.builder("s").longOpt("summary").hasArg().argName("summary")
                  .desc("Plugin summary").required(false).build());
      options.addOption(
            Option.builder("c").longOpt("company").hasArg().argName("company")
                  .desc("Plugin company").required(false).build());
      options.addOption(
            Option.builder("st").longOpt("serverThumbprint").hasArg()
                  .argName("Plugin's server thumbprint")
                  .desc("Thumbprint of the plugin server's SSL certificate.")
                  .required(false).build());
      options.addOption(Option.builder("show").longOpt("showInSolutionManager")
            .desc("If specified the plugin will be shown in Administration panel, Solutions plug-in list")
            .required(false).build());
      options.addOption("remote", false,
            "If specified will register/update a remote plugin");
      options.addOption("local", false,
            "If specified will register/update a local plugin");
      return options;
   }
}
